<?php

namespace App\Helpers;

use Illuminate\Http\Request;

trait DropdownListHelper
{
    /** gender list */
    static function genderList(): array
    {
        return [
            ["id" => "man", "label" => __("messages.word.man")],
            ["id" => "woman", "label" => __("messages.word.woman")],
            ["id" => "unknown", "label" => __("messages.word.unknown")],
        ];
    }

    /** content status list */
    static function contentStatusList(): array
    {
        return [
            ["id" => "publish", "label" => __("messages.word.publish")],
            ["id" => "draft", "label" => __("messages.word.draft")],
        ];
    }

    /** article type list */
    static function articleTypeList(): array
    {
        return [
            ["id" => "text", "label" => __("messages.word.textual")],
            ["id" => "video", "label" => __("messages.word.video")],
            ["id" => "podcast", "label" => __("messages.word.podcast")],
        ];
    }

    /** form type list */
    static function formTypeList(): array
    {
        return [
            ["id" => "text", "label" => __("messages.word.short_text")],
            ["id" => "textarea", "label" => __("messages.word.textarea")],
            ["id" => "checkbox", "label" => __("messages.word.checkbox")],
        ];
    }

    /** form priority list */
    static function formPriorityList(): array
    {
        return [
            ["id" => "necessary", "label" => __("messages.word.necessary")],
            ["id" => "optional", "label" => __("messages.word.optional")],
        ];
    }

    /** form story type list */
    static function formStoryTypeList(): array
    {
        return [
            ["id" => "image", "label" => __("messages.word.image_type")],
            ["id" => "video", "label" => __("messages.word.video_type")],
        ];
    }

    /** form seller type list */
    static function sellerTypeList(): array
    {
        return [
            ["id" => "genuine", "label" => __("messages.word.genuine")],
            ["id" => "legal", "label" => __("messages.word.legal")],
        ];
    }

    /** menu place list */
    static function menuPlaceList(): array
    {
        return [
            ["id" => "header_main", "label" => __("messages.sentence.menu_header_main")],
            ["id" => "footer_main", "label" => __("messages.sentence.menu_footer_main")],
            ["id" => "footer_menu_1", "label" => __("messages.sentence.menu_footer_menu_1")],
            ["id" => "footer_menu_2", "label" => __("messages.sentence.menu_footer_menu_2")],
        ];
    }

    /** video type list */
    static function videoTypeList(): array
    {
        return [
            ["id" => "url", "label" => __("messages.word.direct_url")],
            ["id" => "aparat", "label" => __("messages.word.aparat_embed")],
        ];
    }

    /** sms payment gateway list */
    static function paymentGatewayList(): array
    {
        return [
            [
                "id" => "zarinpal",
                "label" => __('messages.word.zarinpal'),
                "icon" => '/img/gateways/zarinpal.png',
                "status" => true,
                "fields" => [
                    "merchantId" => [
                        'label' => __('messages.word.merchant_id'),
                        'value' => null,
                    ],
                    "mode" => [
                        'label' => 'gateway status',
                        'value' => app()->environment(['local', 'testing']) ? 'sandbox' : 'normal',
                    ]
                ]
            ],
            [
                "id" => "digipay",
                "label" => __('messages.word.digipay'),
                "icon" => '/img/gateways/digipay.png',
                "status" => true,
                "fields" => [
                    "username" => [
                        'label' => __('messages.word.username'),
                        'value' => null,
                    ],
                    "password" => [
                        'label' => __('messages.word.password'),
                        'value' => null,
                    ],
                    "client_id" => [
                        'label' => __('messages.word.client_id'),
                        'value' => null,
                    ],
                    "client_secret" => [
                        'label' => __('messages.word.client_secret'),
                        'value' => null,
                    ],
                ]
            ],
            [
                "id" => "snapppay",
                "label" => __('messages.word.snapppay'),
                "icon" => '/img/gateways/snapppay.svg',
                "status" => true,
                "fields" => [
                    "username" => [
                        'label' => __('messages.word.username'),
                        'value' => null,
                    ],
                    "password" => [
                        'label' => __('messages.word.password'),
                        'value' => null,
                    ],
                    "client_id" => [
                        'label' => __('messages.word.client_id'),
                        'value' => null,
                    ],
                    "client_secret" => [
                        'label' => __('messages.word.client_secret'),
                        'value' => null,
                    ],
                ]
            ],
            [
                "id" => "behpardakht",
                "label" => __('messages.word.behpardakht'),
                "icon" => '/img/gateways/beh_pardakht_mellat.png',
                "status" => true,
                "fields" => [
                    "username" => [
                        'label' => __('messages.word.username'),
                        'value' => null,
                    ],
                    "password" => [
                        'label' => __('messages.word.password'),
                        'value' => null,
                    ],
                    "terminalId" => [
                        'label' => __('messages.word.terminal_id'),
                        'value' => null,
                    ],
                ]
            ],
            [
                "id" => "nextpay",
                "label" => __('messages.word.nextpay'),
                "icon" => '/img/gateways/nextpay.png',
                "status" => true,
                "fields" => [
                    "merchantId" => [
                        'label' => __('messages.word.merchant_id'),
                        'value' => null,
                    ],
                ]
            ],
            [
                "id" => "asanpardakht",
                "label" => __('messages.word.asanpardakht'),
                "icon" => '/img/gateways/asanpardakht.png',
                "status" => true,
                "fields" => [
                    "username" => [
                        'label' => __('messages.word.username'),
                        'value' => null,
                    ],
                    "password" => [
                        'label' => __('messages.word.password'),
                        'value' => null,
                    ],
                    "merchantConfigID" => [
                        'label' => __('messages.word.merchant_config_id'),
                        'value' => null,
                    ],
                ]
            ],
            [
                "id" => "parsian",
                "label" => __('messages.word.parsian'),
                "icon" => '/img/gateways/parsian.png',
                "status" => true,
                "fields" => [
                    "merchantId" => [
                        'label' => __('messages.word.merchant_id'),
                        'value' => null,
                    ],
                ]
            ],
            [
                "id" => "sadad",
                "label" => __('messages.word.sadad'),
                "icon" => '/img/gateways/sadad.png',
                "status" => true,
                "fields" => [
                    "key" => [
                        'label' => __('messages.word.key') . ' - key',
                        'value' => null,
                    ],
                    "merchantId" => [
                        'label' => __('messages.word.merchant_id'),
                        'value' => null,
                    ],
                    "terminalId" => [
                        'label' => __('messages.word.terminal_id'),
                        'value' => null,
                    ],
                ]
            ],
            /*[
                "id" => "saman",
                "label" => __('messages.word.saman'),
                "icon" => '/img/gateways/saman.png',
                "status" => true,
                "fields" => [
                    "merchantId" => [
                        'label' => __('messages.word.merchant_id'),
                        'value' => null,
                    ],
                    "password" => [
                        'label' => __('messages.word.password'),
                        'value' => null,
                    ],
                ]
            ],*/
            [
                "id" => "sep",
                "label" => __('messages.word.sep'),
                "icon" => '/img/gateways/saman.png',
                "status" => true,
                "fields" => [
                    "terminalId" => [
                        'label' => __('messages.word.terminal_id'),
                        'value' => null,
                    ],
                ]
            ],
            [
                "id" => "pasargad",
                "label" => __('messages.word.pasargad'),
                "icon" => '/img/gateways/pasargad.png',
                "status" => true,
                "fields" => [
                    "userName" => [
                        'label' => __('messages.word.username'),
                        'value' => null,
                    ],
                    "password" => [
                        'label' => __('messages.word.password'),
                        'value' => null,
                    ],
                    "merchantId" => [
                        'label' => __('messages.word.merchant_id'),
                        'value' => null,
                    ],
                    "terminalCode" => [
                        'label' => __('messages.word.terminal_code'),
                        'value' => null,
                    ],
                ]
            ],
            [
                "id" => "sepehr",
                "label" => __('messages.word.sepehr'),
                "icon" => '/img/gateways/sepehr.png',
                "status" => true,
                "fields" => [
                    "terminalId" => [
                        'label' => __('messages.word.terminal_id'),
                        'value' => null,
                    ],
                ]
            ],
            [
                "id" => "parspal",
                "label" => __('messages.word.parspal'),
                "icon" => '/img/gateways/parspal.png',
                "status" => true,
                "fields" => [
                    "merchantId" => [
                        'label' => __('messages.word.merchant_id'),
                        'value' => null,
                    ],
                ]
            ],
            [
                "id" => "zibal",
                "label" => __('messages.word.zibal'),
                "icon" => '/img/gateways/zibal.png',
                "status" => true,
                "fields" => [
                    "merchantId" => [
                        'label' => __('messages.word.merchant_id'),
                        'value' => null,
                    ],
                ]
            ],
            [
                "id" => "aqayepardakht",
                "label" => __('messages.word.aqayepardakht'),
                "icon" => '/img/gateways/aqayepardakht.png',
                "status" => true,
                "fields" => [
                    "pin" => [
                        'label' => __('messages.word.pin'),
                        'value' => null,
                    ]
                ]
            ],
            [
                "id" => "toman",
                "label" => __('messages.word.toomaan'),
                "icon" => '/img/gateways/toomaan.png',
                "status" => true,
                "fields" => [
                    "shop_slug" => [
                        'label' => 'shop slug',
                        'value' => null,
                    ],
                    "auth_code" => [
                        'label' => 'auth code',
                        'value' => null,
                    ]
                ]
            ],
            [
                "id" => "azki",
                "label" => __('messages.word.azki'),
                "icon" => '/img/gateways/azki.png',
                "status" => true,
                "fields" => [
                    "merchantId" => [
                        'label' => __('messages.word.merchant_id'),
                        'value' => null,
                    ],
                    "key" => [
                        'label' => __('messages.word.key') . ' - key',
                        'value' => null,
                    ],
                ]
            ],
            [
                "id" => "shepa",
                "label" => __('messages.word.shepa'),
                "icon" => '/img/gateways/shepa.png',
                "status" => true,
                "fields" => [
                    "merchantId" => [
                        'label' => __('messages.word.merchant_id'),
                        'value' => null,
                    ],
                    "sandbox" => [
                        'label' => 'gateway status',
                        'value' => app()->environment(['local', 'testing']) ? true : false,
                    ]
                ]
            ],
            [
                "id" => "vandar",
                "label" => __('messages.word.vandar'),
                "icon" => '/img/gateways/vandar.png',
                "status" => true,
                "fields" => [
                    "merchantId" => [
                        'label' => __('messages.word.merchant_id'),
                        'value' => null,
                    ],
                ]
            ],
            [
                "id" => "payping",
                "label" => __('messages.word.payping'),
                "icon" => '/img/gateways/payping.webp',
                "status" => true,
                "fields" => [
                    "merchantId" => [
                        'label' => __('messages.word.merchant_id'),
                        'value' => null,
                    ],
                ]
            ],
            /*[
                "id" => "kipaa",
                "label" => __('messages.word.kipaa'),
                "icon" => '/img/gateways/kipaa.webp',
                "status" => true,
                "fields" => [
                    "apiKey" => [
                        'label' => __('messages.word.api_key'),
                        'value' => null,
                    ],
                ]
            ],*/
        ];
    }

    /** sms panel list */
    static function smsPanelList(): array
    {
        return [
            [
                "id" => "kavenegar",
                "label" => __('messages.word.kavenegar'),
                "fields" => [
                    "information" => [
                        "api_key" => '',
                    ],
                    "pattern" => [
                        "auth" => [
                            'id' => 1,
                            'value' => '',
                        ],
                        "productStatus" => [
                            'id' => 2,
                            'value' => '',
                        ],
                        "storeStatus" => [
                            'id' => 3,
                            'value' => '',
                        ],
                        "inventoryStatus" => [
                            'id' => 4,
                            'value' => '',
                        ],
                        "orderRegistration" => [
                            'id' => 5,
                            'value' => '',
                        ],
                        "withdrawalDeposited" => [
                            'id' => 6,
                            'value' => '',
                        ],
                        "walletCharge" => [
                            'id' => 7,
                            'value' => '',
                        ],
                        "requestConsignment" => [
                            'id' => 8,
                            'value' => '',
                        ],
                        "orderCancellation" => [
                            'id' => 9,
                            'value' => '',
                        ],
                        "orderSentWithCancelled" => [
                            'id' => 10,
                            'value' => '',
                        ],
                        "orderSent" => [
                            'id' => 11,
                            'value' => '',
                        ],
                        "abandonedCart" => [
                            'id' => 12,
                            'value' => '',
                        ],
                        "PrefactorIssued" => [
                            'id' => 13,
                            'value' => '',
                        ],
                        "sellerMainStorageSendOrderStatus" => [
                            'id' => 14,
                            'value' => '',
                        ],
                        "sellerDirectSendOrderStatus" => [
                            'id' => 15,
                            'value' => '',
                        ],
                    ],
                ]
            ],
            [
                "id" => "farazsms",
                "label" => __('messages.word.farazsms'),
                "fields" => [
                    "information" => [
                        "api_key" => '',
                    ],
                    "pattern" => [
                        "auth" => [
                            'id' => 1,
                            'value' => '',
                        ],
                        "productStatus" => [
                            'id' => 2,
                            'value' => '',
                        ],
                        "storeStatus" => [
                            'id' => 3,
                            'value' => '',
                        ],
                        "inventoryStatus" => [
                            'id' => 4,
                            'value' => '',
                        ],
                        "orderRegistration" => [
                            'id' => 5,
                            'value' => '',
                        ],
                        "withdrawalDeposited" => [
                            'id' => 6,
                            'value' => '',
                        ],
                        "walletCharge" => [
                            'id' => 7,
                            'value' => '',
                        ],
                        "requestConsignment" => [
                            'id' => 8,
                            'value' => '',
                        ],
                        "orderCancellation" => [
                            'id' => 9,
                            'value' => '',
                        ],
                        "orderSentWithCancelled" => [
                            'id' => 10,
                            'value' => '',
                        ],
                        "orderSent" => [
                            'id' => 11,
                            'value' => '',
                        ],
                        "abandonedCart" => [
                            'id' => 12,
                            'value' => '',
                        ],
                        "PrefactorIssued" => [
                            'id' => 13,
                            'value' => '',
                        ],
                        "sellerMainStorageSendOrderStatus" => [
                            'id' => 14,
                            'value' => '',
                        ],
                        "sellerDirectSendOrderStatus" => [
                            'id' => 15,
                            'value' => '',
                        ],
                    ],
                ]
            ],
            [
                "id" => "ghasedak",
                "label" => __('messages.word.ghasedak'),
                "fields" => [
                    "information" => [
                        "api_key" => '',
                    ],
                    "pattern" => [
                        "auth" => [
                            'id' => 1,
                            'value' => '',
                        ],
                        "productStatus" => [
                            'id' => 2,
                            'value' => '',
                        ],
                        "storeStatus" => [
                            'id' => 3,
                            'value' => '',
                        ],
                        "inventoryStatus" => [
                            'id' => 4,
                            'value' => '',
                        ],
                        "orderRegistration" => [
                            'id' => 5,
                            'value' => '',
                        ],
                        "withdrawalDeposited" => [
                            'id' => 6,
                            'value' => '',
                        ],
                        "walletCharge" => [
                            'id' => 7,
                            'value' => '',
                        ],
                        "requestConsignment" => [
                            'id' => 8,
                            'value' => '',
                        ],
                        "orderCancellation" => [
                            'id' => 9,
                            'value' => '',
                        ],
                        "orderSentWithCancelled" => [
                            'id' => 10,
                            'value' => '',
                        ],
                        "orderSent" => [
                            'id' => 11,
                            'value' => '',
                        ],
                        "abandonedCart" => [
                            'id' => 12,
                            'value' => '',
                        ],
                        "PrefactorIssued" => [
                            'id' => 13,
                            'value' => '',
                        ],
                        "sellerMainStorageSendOrderStatus" => [
                            'id' => 14,
                            'value' => '',
                        ],
                        "sellerDirectSendOrderStatus" => [
                            'id' => 15,
                            'value' => '',
                        ],
                    ],
                ]
            ],
            [
                "id" => "melipayamak",
                "label" => __('messages.word.melipayamak'),
                "fields" => [
                    "information" => [
                        "username" => '',
                        "password" => '',
                    ],
                    "pattern" => [
                        "auth" => [
                            'id' => 1,
                            'value' => '',
                        ],
                        "productStatus" => [
                            'id' => 2,
                            'value' => '',
                        ],
                        "storeStatus" => [
                            'id' => 3,
                            'value' => '',
                        ],
                        "inventoryStatus" => [
                            'id' => 4,
                            'value' => '',
                        ],
                        "orderRegistration" => [
                            'id' => 5,
                            'value' => '',
                        ],
                        "withdrawalDeposited" => [
                            'id' => 6,
                            'value' => '',
                        ],
                        "walletCharge" => [
                            'id' => 7,
                            'value' => '',
                        ],
                        "requestConsignment" => [
                            'id' => 8,
                            'value' => '',
                        ],
                        "orderCancellation" => [
                            'id' => 9,
                            'value' => '',
                        ],
                        "orderSentWithCancelled" => [
                            'id' => 10,
                            'value' => '',
                        ],
                        "orderSent" => [
                            'id' => 11,
                            'value' => '',
                        ],
                        "abandonedCart" => [
                            'id' => 12,
                            'value' => '',
                        ],
                        "PrefactorIssued" => [
                            'id' => 13,
                            'value' => '',
                        ],
                        "sellerMainStorageSendOrderStatus" => [
                            'id' => 14,
                            'value' => '',
                        ],
                        "sellerDirectSendOrderStatus" => [
                            'id' => 15,
                            'value' => '',
                        ],
                    ],
                ]
            ],
            [
                "id" => "smsir",
                "label" => __('messages.word.smsir'),
                "fields" => [
                    "information" => [
                        "api_key" => '',
                    ],
                    "pattern" => [
                        "auth" => [
                            'id' => 1,
                            'value' => '',
                        ],
                        "productStatus" => [
                            'id' => 2,
                            'value' => '',
                        ],
                        "storeStatus" => [
                            'id' => 3,
                            'value' => '',
                        ],
                        "inventoryStatus" => [
                            'id' => 4,
                            'value' => '',
                        ],
                        "orderRegistration" => [
                            'id' => 5,
                            'value' => '',
                        ],
                        "withdrawalDeposited" => [
                            'id' => 6,
                            'value' => '',
                        ],
                        "walletCharge" => [
                            'id' => 7,
                            'value' => '',
                        ],
                        "requestConsignment" => [
                            'id' => 8,
                            'value' => '',
                        ],
                        "orderCancellation" => [
                            'id' => 9,
                            'value' => '',
                        ],
                        "orderSentWithCancelled" => [
                            'id' => 10,
                            'value' => '',
                        ],
                        "orderSent" => [
                            'id' => 11,
                            'value' => '',
                        ],
                        "abandonedCart" => [
                            'id' => 12,
                            'value' => '',
                        ],
                        "PrefactorIssued" => [
                            'id' => 13,
                            'value' => '',
                        ],
                        "sellerMainStorageSendOrderStatus" => [
                            'id' => 14,
                            'value' => '',
                        ],
                        "sellerDirectSendOrderStatus" => [
                            'id' => 15,
                            'value' => '',
                        ],
                    ],
                ]
            ],
        ];
    }

    /** sms panel list */
    static function ticketPriorityList(): array
    {
        return [
            ["id" => "low", "label" => __("messages.word.low")],
            ["id" => "normal", "label" => __("messages.word.average")],
            ["id" => "high", "label" => __("messages.word.high")],
        ];
    }

    /** wallet related amount list */
    static function walletRelatedAmounts(): array
    {
        return [
            500000,
            1000000,
            2000000,
            5000000,
            10000000,
        ];
    }

    /** wallet related amount list */
    static function companyType(): array
    {
        return [
            ['id' => "public_company", 'label' => __("messages.word.public_company")],
            ['id' => "private_equity", 'label' => __("messages.word.private_equity")],
            ['id' => "limited_liability", 'label' => __("messages.word.limited_liability")],
            ['id' => "cooperative", 'label' => __("messages.word.cooperative")],
            ['id' => "solidarity", 'label' => __("messages.word.solidarity")],
            ['id' => "institute", 'label' => __("messages.word.institute")],
            ['id' => "other", 'label' => __("messages.word.other")],
        ];
    }

    /** abandoned cart time period list */
    static function abandonedCartTimePeriod(): array
    {
        return [
            ['id' => "360", 'label' => __("messages.sentence.after_6_hours")],
            ['id' => "720", 'label' => __("messages.sentence.after_12_hours")],
            ['id' => "1440", 'label' => __("messages.sentence.after_1_days")],
            ['id' => "2880", 'label' => __("messages.sentence.after_2_days")],
            ['id' => "5760", 'label' => __("messages.sentence.after_4_days")],
            ['id' => "10080", 'label' => __("messages.sentence.after_7_days")],
        ];
    }
}
