<?php

namespace App\Helpers;

use App\Models\User;

trait ReportHelper
{
    /** register report */
    public function report($content, $targetType = null, $target = null): void
    {
        /** @var \App\Models\User $user **/
        $user = auth()->user();

        // content with current user information
        $content = $this->getCurrentUserContent($user, $content);

        // content with current user information
        $content = $this->getTargetContent($target, $targetType, $content);

        // do report
        $user->reports()->create([
            'content' => $content,
            'type' => $user->seller ? 'seller' : $user->type
        ]);
    }

    /** user type */
    public function getUserType(User $user): string
    {
        $type = __('messages.word.user');
        if ($user->type == "owner") {
            $type = __('messages.word.owner');
        } else if ($user->type == "admin") {
            $type = __('messages.word.admin');
        } else if ($user->seller) {
            $type = __('messages.word.seller');
        } else if ($user->type == "user") {
            $type = __('messages.word.user');
        }
        return $type;
    }

    /** init current user information */
    public function getCurrentUserContent(User $user, string $content)
    {
        // current user type
        $content = str_replace('[current_type]', $this->getUserType($user), $content);

        // current user name and link
        $content = str_replace('[current_name]', '<span class="link-to-target link lts-05" target="user" parameter="' . $user->id . '">' . $user->get_name . '</span>', $content);

        return $content;
    }

    /** init target information */
    public function getTargetContent($target, $targetType, string $content): null | string
    {
        if ($target != null) {
            // target type
            if ($targetType == "user")
                $content = str_replace('[target_type]', $this->getUserType($target), $content);
            else
                $content = str_replace('[target_type]', __('messages.word.' . $targetType), $content);


            // target name and link
            switch ($targetType) {
                case "user":
                    $content = str_replace('[target_name]', '<span class="link-to-target link lts-05" target="user" parameter="' . $target->id . '">' . $target->get_name . '</span>', $content);
                    break;
                case "brand":
                    $targetName = $target->title;
                    $content = str_replace('[target_name]', '<span class="link-to-target link lts-05" target="brand" parameter="' . $target->slug . '">' . $targetName . '</span>', $content);
                    break;
                case "category":
                    $targetName = $target->title;
                    $content = str_replace('[target_name]', '<span class="link-to-target link lts-05" target="category" parameter="' . $target->slug . '">' . $targetName . '</span>', $content);
                    break;
                case "article_category":
                    $targetName = $target->title;
                    $content = str_replace('[target_name]', '<span class="link-to-target link lts-05" target="article_category" parameter="' . $target->slug . '">' . $targetName . '</span>', $content);
                    break;
                case "tag":
                    $targetName = $target->title;
                    $content = str_replace('[target_name]', '<span class="link-to-target link lts-05" target="tag" parameter="' . $target->slug . '">' . $targetName . '</span>', $content);
                    break;
                case "article_tag":
                    $targetName = $target->title;
                    $content = str_replace('[target_name]', '<span class="link-to-target link lts-05" target="article_tag" parameter="' . $target->slug . '">' . $targetName . '</span>', $content);
                    break;
                case "product":
                    $targetName = $target->title;
                    $content = str_replace('[target_name]', '<span class="link-to-target link lts-05" target="product" parameter="' . $target->slug . '">' . $targetName . '</span>', $content);
                    break;
                case "page":
                    $targetName = $target->title;
                    $content = str_replace('[target_name]', '<span class="link-to-target link lts-05" target="page" parameter="' . $target->slug . '">' . $targetName . '</span>', $content);
                    break;
                case "form":
                    $targetName = $target->title;
                    $content = str_replace('[target_name]', '<span class="link-to-target link lts-05" target="form" parameter="' . $target->slug . '">' . $targetName . '</span>', $content);
                    break;
                case "ticket":
                    $targetName = $target->title;
                    $content = str_replace('[target_name]', '<span class="link-to-target link lts-05" target="ticket" parameter="' . $target->id . '">' . $targetName . '</span>', $content);
                    break;
                case "store":
                    $targetName = $target->name;
                    $content = str_replace('[target_name]', '<span class="link-to-target link lts-05" target="store" parameter="' . $target->uuid . '">' . $targetName . '</span>', $content);
                    break;
                case "article":
                    $targetName = $target->title;
                    $content = str_replace('[target_name]', '<span class="link-to-target link lts-05" target="article" parameter="' . $target->slug . '">' . $targetName . '</span>', $content);
                    break;
            }
        }

        return $content;
    }
}
