<?php

namespace App\Helpers;

use Illuminate\Support\Facades\Route;

trait SmsPatternGuide
{
    use CommonFunctionsHelper;

    private $guides = [
        [
            "id" => 1,
            "text" =>
            'کد ورود شما: token_one

            (نام فروشگاه)'
        ],
        [
            "id" => 2,
            "text" =>
            'فروشنده گرامی,
            محصول ایجاد شده توسط شما با شناسه: token_one تغییر وضعیت یافت.
            وضعیت جدید: token_two شده
            برای اطلاعات بیشتر به صفحه محصول در پنل فروشندگی مراجعه کنید.

            (نام فروشگاه)'
        ],
        [
            "id" => 3,
            "text" =>
            'فروشنده گرامی,
            درخواست شما برای فروشندگی تغییر وضعیت یافت.
            وضعیت جدید: token_one شد
            برای اطلاعات بیشتر به پنل فروشندگی مراجعه نمایید.

            (نام فروشگاه)'
        ],
        [
            "id" => 4,
            "text" =>
            'فروشنده گرامی,
            قیمت ایجاد شده توسط شما با شناسه: token_one تغییر وضعیت یافت.
            وضعیت جدید: token_two شده
            برای اطلاعات بیشتر به بخش انبارداری در پنل فروشندگی مراجعه کنید.

            (نام فروشگاه)'
        ],
        [
            "id" => 5,
            "text" =>
            'سفارش شما با موفقیت پرداخت و در صف پردازش قرار گرفت.
            شماره پیگیری: token_one
            جهت مشاهده جزئیات سفارش و دریافت فاکتور به پنل کاربری خود مراجعه نمایید.

            (نام فروشگاه)'
        ],
        [
            "id" => 6,
            "text" =>
            'درخواست برداشت وجه شما با شماره تراکنش token_one با موفقیت به حسابتان واریز شد.
            کد پیگیری بانکی: token_two

            (نام فروشگاه)'
        ],
        [
            "id" => 7,
            "text" =>
            'پرداخت شما با موفقیت انجام شد و کیف پولتان به میزان token_one تومان شارژ شد.
            شماره تراکنش: token_two

            (نام فروشگاه)'
        ],
        [
            "id" => 8,
            "text" =>
            'یک سفارش با شناسه token_one ثبت شد و در انتظار بررسی و ارسال شما میباشد.
            لطفا سریعتر سفارش ثبت شده را بررسی کرده و وضعیت آن را مشخص کنید.

            (نام فروشگاه)'
        ],
        [
            "id" => 9,
            "text" =>
            'مرسوله شماره token_one از سفارش شماره token_two لغو شد.
            با مراجعه به بخش سفارشات در پنل کاربری از دلیل لغو مطلع شوید.
            مبلغ لغو شده به کیف پول شما بازگشت داده شد, میتوانید از طریق پنل کاربری درخواست برداشت به حساب بانکی ثبت کنید و یا برای ثبت سفارش دیگر از این مبلغ استفاده کنید.

            (نام فروشگاه)'
        ],
        [
            "id" => 10,
            "text" =>
            'مرسوله شماره token_one از سفارش شماره token_two ارسال شد.
            کد رهگیری پستی: token_three
            برخی از آیتم های مرسوله لغو شده اند و مبلغ لغو شده به کیف پول شما برگشت داده شد.
            با مراجعه به پنل کاربری میتوانید درخواست برداشت به حساب بانکی ثبت کنید و یا برای ثبت سفارش جدید از این مبلغ استفاده کنید.
            همچنین از قسمت سفارشات در پنل کاربری میتوانید اقدام به دریافت فاکتور فروش نمایید.

            (نام فروشگاه)'
        ],
        [
            "id" => 11,
            "text" =>
            'مرسوله شماره token_one از سفارش شماره token_two ارسال شد.
            کد رهگیری پستی: token_three
            با مراجعه به قسمت سفارشات در پنل کاربری میتوانید جزئیات سفارش را مشاهده کرده و فاکتور فروش را دریافت کنید.

            (نام فروشگاه)'
        ],
        [
            "id" => 12,
            "text" =>
            'token_one عزیز,
            سفارش با شناسه token_two شما در سبد خرید در انتظار پرداخت میباشد.
            به دلیل حجم بالای سفارشات و احتمال اتمام موجودی, قبل از لغو کالا ها سفارشتان را نهایی کنید.

            (نام فروشگاه)'
        ],
        [
            "id" => 13,
            "text" =>
            'مشتری گرامی,
            فاکتور با شماره token_one برای شما صادر گردید و مهلت پرداخت تا تاریخ token_two میباشد.
            از طریق لینک زیر و یا پنل کاربری میتوانید نسبت به مشاهده جزئیات و پرداخت اقدام نمایید:
            prefactor_route_token_three

            (نام فروشگاه)'
        ],
        [
            "id" => 14,
            "text" =>
            'مدیریت گرامی,
            مرسوله شماره token_one از سفارش شماره token_two که با وضعیت (ارسال به انبار مرکزی) میباشد, توسط فروشنده token_three شد.

            (نام فروشگاه)'
        ],
        [
            "id" => 15,
            "text" =>
            'مدیریت گرامی,
            مرسوله شماره token_one از سفارش شماره token_two که با وضعیت (ارسال مستقیم فروشنده) میباشد, توسط فروشنده token_three شد.

            (نام فروشگاه)'
        ],
    ];

    // kavenegar
    public function kavenegar(): array
    {
        $guides = $this->guides;

        foreach ($guides as &$guide) {
            $guide['text'] = str_replace('prefactor_route_token_three', str_replace('{uuid}', 'token_three', url(Route::getRoutes()->getByName('prefactor.shiping')->uri())), $guide['text']);

            $guide['text'] = str_replace('token_one', '%token', $guide['text']);
            $guide['text'] = str_replace('token_two', '%token2', $guide['text']);
            $guide['text'] = str_replace('token_three', '%token3', $guide['text']);
            $guide['text'] = str_replace('(نام فروشگاه)', $_SERVER['SERVER_NAME'], $guide['text']);
        }

        return $guides;
    }

    // farazsms
    public function farazsms(): array
    {
        $guides = $this->guides;

        foreach ($guides as &$guide) {
            $guide['text'] = str_replace('prefactor_route_token_three', str_replace('{uuid}', 'token_three', url(Route::getRoutes()->getByName('prefactor.shiping')->uri())), $guide['text']);

            $guide['text'] = str_replace('token_one', '%token_one%', $guide['text']);
            $guide['text'] = str_replace('token_two', '%token_two%', $guide['text']);
            $guide['text'] = str_replace('token_three', '%token_three%', $guide['text']);
            $guide['text'] = str_replace('(نام فروشگاه)', $_SERVER['SERVER_NAME'], $guide['text']);
        }

        return $guides;
    }

    // melipayamak
    public function ghasedak(): array
    {
        $guides = $this->guides;

        foreach ($guides as &$guide) {
            $guide['text'] = str_replace('prefactor_route_token_three', str_replace('{uuid}', 'token_three', url(Route::getRoutes()->getByName('prefactor.shiping')->uri())), $guide['text']);

            $guide['text'] = str_replace('token_one', '%token_one%', $guide['text']);
            $guide['text'] = str_replace('token_two', '%token_two%', $guide['text']);
            $guide['text'] = str_replace('token_three', '%token_three%', $guide['text']);
            $guide['text'] = str_replace('(نام فروشگاه)', $_SERVER['SERVER_NAME'], $guide['text']);
        }

        return $guides;
    }

    // melipayamak
    public function melipayamak(): array
    {
        $guides = $this->guides;

        foreach ($guides as &$guide) {
            $guide['text'] = str_replace('prefactor_route_token_three', str_replace('{uuid}', 'token_three', url(Route::getRoutes()->getByName('prefactor.shiping')->uri())), $guide['text']);

            $guide['text'] = str_replace('token_one', '{0}', $guide['text']);
            $guide['text'] = str_replace('token_two', '{1}', $guide['text']);
            $guide['text'] = str_replace('token_three', '{2}', $guide['text']);
            $guide['text'] = str_replace('(نام فروشگاه)', $_SERVER['SERVER_NAME'], $guide['text']);
        }

        return $guides;
    }

    // smsir
    public function smsir(): array
    {
        $guides = $this->guides;

        foreach ($guides as &$guide) {
            $guide['text'] = str_replace('prefactor_route_token_three', str_replace('{uuid}', 'token_three', url(Route::getRoutes()->getByName('prefactor.shiping')->uri())), $guide['text']);

            $guide['text'] = str_replace('token_one', '#token_one#', $guide['text']);
            $guide['text'] = str_replace('token_two', '#token_two#', $guide['text']);
            $guide['text'] = str_replace('token_three', '#token_three#', $guide['text']);
            $guide['text'] = str_replace('(نام فروشگاه)', $_SERVER['SERVER_NAME'], $guide['text']);
        }

        return $guides;
    }
}
