<?php

namespace App\Helpers;

use Illuminate\Database\Eloquent\Model;

trait UUIDHelper
{
    function generateUniqueRandomNumber(int $length, string $modelClass, string $column, string $prefix = ''): string
    {
        do {
            // ساخت عدد رندوم با طول مشخص
            if ($length >= 10) {
                // رقم اول هرگز صفر نباشد
                $randomNumber = (string) random_int(1, 9);
                for ($i = 1; $i < $length; $i++) {
                    $randomNumber .= random_int(0, 9);
                }
            } else {
                $min = (int) str_pad('1', $length, '0'); // شروع از 1، پس عدد اول صفر نمی‌شود
                $max = (int) str_pad('', $length, '9');
                $randomNumber = (string) random_int($min, $max);
            }

            $finalValue = $prefix . $randomNumber;

            // چک کردن وجود در دیتابیس
            $exists = $modelClass::where($column, $finalValue)->exists();
        } while ($exists);

        return $finalValue;
    }
}
