<?php

namespace App\Http\Controllers\Admin\Blog;

use App\Models\ArticleTag;
use App\Http\Controllers\Controller;
use App\Services\Admin\Blog\ArticleTagsService;
use Illuminate\Http\Request;
use Inertia\Inertia;

class ArticleTagsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request, ArticleTagsService $articleTagsService)
    {
        return Inertia::render('Admin/Blog/Tags/List', [
            'tags' => $articleTagsService->getTags($request)
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(ArticleTag $tag)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(ArticleTag $tag)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, ArticleTag $tag)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ArticleTag $tag)
    {
        $tag->delete();

        /** Report Action */
        $this->report(__("messages.report_tag_deleted"), 'article_tag', $tag);

        return redirect()->back()->with('message', [__('messages.tag_deleted')]);
    }
}
