<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Article;
use App\Models\OrderGroup;
use App\Models\Product;
use App\Models\Store;
use App\Models\Ticket;
use App\Models\Transaction;
use App\Models\User;
use App\Services\Admin\DashboardService;
use App\Services\Admin\Financial\SalesChartsService;
use App\Services\Admin\Statistics\StatisticsService;
use Inertia\Inertia;

class DashboardController extends Controller
{
    public function index(DashboardService $dashboardService, StatisticsService $statisticsService, SalesChartsService $salesChartsService)
    {
        // view charts
        $viewCharts = $statisticsService->getViewCharts(6);

        return Inertia::render('Admin/Dashboard', [
            'counts' => fn() => [
                'products' => Product::where('status', 'publish')->count(),
                'articles' => Article::where('status', 'publish')->count(),
                'sellers' => Store::where('status', 'active')->orWhere('status', 'banned')->count(),
                'users' => User::count(),
                'tickets' => Ticket::count(),
                'orders' => OrderGroup::count(),
                'transactions' => Transaction::where('status', 'accepted')->count(),
            ],
            'pageView' => fn() => [
                'dates' => $viewCharts['dates'],
                'totalPageView' => $viewCharts['totalPageView'],
                'shop' => [
                    'label' => __('messages.word.shop'),
                    'views' => $viewCharts['shopPageView'],
                ],
                'blog' => [
                    'label' => __('messages.word.blog'),
                    'views' => $viewCharts['blogPageView'],
                ],
            ],
            'pageUniqueView' => fn() => [
                'dates' => $viewCharts['dates'],
                'totalPageUniqueView' => $viewCharts['totalPageUniqueView'],
                'shop' => [
                    'label' => __('messages.word.shop'),
                    'views' => $viewCharts['shopPageUniqueView'],
                ],
                'blog' => [
                    'label' => __('messages.word.blog'),
                    'views' => $viewCharts['blogPageUniqueView'],
                ],
            ],
            'totalSales' => fn() => $salesChartsService->getTotalSalesChart(7),
            'orders' => fn() => $dashboardService->getLatestOrders(5),
            'mostViewedProductsOfMonth' => fn() => $dashboardService->getMostViewedProductsOfMonth(8),
        ]);
    }
}
