<?php

namespace App\Http\Controllers\Admin\Products;

use App\Models\ProductTag;
use App\Http\Controllers\Controller;
use App\Services\Admin\Products\ProductTagsService;
use Illuminate\Http\Request;
use Inertia\Inertia;

class ProductTagsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request, ProductTagsService $productTagsService)
    {
        return Inertia::render('Admin/Products/Tags/List', [
            'tags' => $productTagsService->getTags($request)
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(ProductTag $tag)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(ProductTag $tag)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, ProductTag $tag)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ProductTag $tag)
    {
        $tag->delete();

        /** Report Action */
        $this->report(__("messages.report_tag_deleted"), 'tag', $tag);

        return redirect()->back()->with('message', [__('messages.tag_deleted')]);
    }
}
