<?php

namespace App\Http\Controllers\Admin\Statistics;

use App\Http\Controllers\Controller;
use App\Models\Statistic;
use App\Services\Admin\Financial\SalesChartsService;
use App\Services\Admin\Statistics\StatisticsService;
use Illuminate\Http\Request;
use Inertia\Inertia;

class StatisticsController extends Controller
{
    /**
     * show all statistics
     */
    public function tracking_view()
    {
        $statisitcs = Statistic::orderBy('created_at', 'desc')->paginate(20)->through(fn($statisitc) => [
            'id' => $statisitc->id,
            'url' => $statisitc->url,
            'get_user' => $statisitc->get_user,
            'ip' => $statisitc->ip,
            'get_platform' => $statisitc->get_platform,
            'get_service' => $statisitc->get_service,
            'os' => $statisitc->os,
            'browser' => $statisitc->browser,
            'jalali_created_at' => $statisitc->jalali_created_at,
        ]);

        return Inertia::render('Admin/Statistics/TrackingView', [
            'statistics' => $statisitcs
        ]);
    }

    /**
     * show view charts
     */
    public function view_chart(StatisticsService $statisticsService)
    {
        // view charts
        $viewCharts = $statisticsService->getViewCharts(30);

        // operation systems chart
        $operationSystems = [
            'Windows' => Statistic::where('os', 'Windows')->count(),
            'Android' => Statistic::where('os', 'Android')->count(),
            'Mac' => Statistic::where('os', 'Mac')->count(),
            'iPhone' => Statistic::where('os', 'iPhone')->count(),
            'iPod' => Statistic::where('os', 'iPod')->count(),
            'Linux' => Statistic::where('os', 'Linux')->count(),
        ];

        // browsers chart
        $browsers = [
            'Google Chrome' => Statistic::where('browser', 'like', "%Google Chrome%")->count(),
            'Firefox' => Statistic::where('browser', 'like', "%Mozilla Firefox%")->count(),
            'Apple Safari' => Statistic::where('browser', 'like', "%Apple Safari%")->count(),
            'Edge' => Statistic::where('browser', 'like', "%Edge%")->count(),
        ];

        return Inertia::render('Admin/Statistics/ViewChart', [
            'pageView' => [
                'dates' => $viewCharts['dates'],
                'totalPageView' => $viewCharts['totalPageView'],
                'shop' => [
                    'label' => __('messages.word.shop'),
                    'views' => $viewCharts['shopPageView'],
                ],
                'blog' => [
                    'label' => __('messages.word.blog'),
                    'views' => $viewCharts['blogPageView'],
                ],
            ],
            'pageUniqueView' => [
                'dates' => $viewCharts['dates'],
                'totalPageUniqueView' => $viewCharts['totalPageUniqueView'],
                'shop' => [
                    'label' => __('messages.word.shop'),
                    'views' => $viewCharts['shopPageUniqueView'],
                ],
                'blog' => [
                    'label' => __('messages.word.blog'),
                    'views' => $viewCharts['blogPageUniqueView'],
                ],
            ],
            'operationSystems' => [
                'data' => array_values($operationSystems),
                'labels' => array_keys($operationSystems),
            ],
            'browsers' => [
                'data' => array_values($browsers),
                'labels' => array_keys($browsers),
            ],
        ]);
    }

    /**
     * products statistics
     */
    public function products(Request $request, StatisticsService $statisticsService)
    {
        return Inertia::render('Admin/Statistics/Products', [
            'productsSales' => $statisticsService->getProductsSales($request),
            'productsVisit' => $statisticsService->getProductsVisits($request),
        ]);
    }

    /**
     * articles statistics
     */
    public function articles(Request $request, StatisticsService $statisticsService)
    {
        return Inertia::render('Admin/Statistics/Articles', [
            'articlesVisit' => $statisticsService->getArticlesVisits($request),
        ]);
    }

    /**
     * financial statistics
     */
    public function financial(Request $request, SalesChartsService $salesChartsService)
    {
        return Inertia::render('Admin/Statistics/Financial', [
            'mainStatistics' => $salesChartsService->getMainStatistics(),
            'totalSales' => fn() => $salesChartsService->getTotalSalesChart(30),
            'mainStoreSales' => fn() => $salesChartsService->getTotalSalesChart(30, 'main'),
            'sellersSales' => fn() => $salesChartsService->getTotalSalesChart(30, 'sellers'),
            'affiliatesSales' => fn() => $salesChartsService->getTotalSalesChart(30, 'affiliate'),
        ]);
    }
}
