<?php

namespace App\Http\Controllers\Api\v1\Torob;

use App\Http\Controllers\Controller;
use App\Models\Product;
use Illuminate\Http\Request;

class TorobProductsController extends Controller
{
    /**
     * show products
     */
    public function index(Request $request)
    {
        $products = Product::where('status', 'publish')->orderBy('updated_at', 'desc')->paginate(100)
            ->through(function ($product) {
                $props = [];

                if ($product->best_inventory && isset($product->best_inventory['props'])) {
                    $propsCollection = collect($product->best_inventory['props']);

                    // رنگ
                    $colorProp = $propsCollection->firstWhere('name', 'رنگ');
                    if ($colorProp && isset($colorProp['value']) && is_array($colorProp['value'])) {
                        $props['color'] = $colorProp['value']['label'];
                    }

                    // گارانتی
                    $guaranteeProp = $propsCollection->firstWhere('name', 'گارانتی');
                    if ($guaranteeProp && isset($guaranteeProp['value'])) {
                        $props['guarantee'] = $guaranteeProp['value'];
                    }

                    // اصالت
                    if ($product->best_inventory) {
                        $props['original'] = $product->best_inventory['original'];
                    }

                    // وضعیت
                    if ($product->best_inventory) {
                        $props['used'] = $product->best_inventory['used'];
                    }
                }

                return [
                    'product_id' => $product->uuid,
                    'title' => $product->title,
                    'image' => $product->get_images[0]['link'],
                    'page_url' => route('main.products.show', $product->slug),
                    'price' => $product->inventory && $product->in_stock_status ? $product->best_price : null,
                    'old_price' => $product->inventory && $product->in_stock_status && $product->has_discount ? $product->best_inventory['price'] : null,
                    'availability' => $product->inventory && $product->in_stock_status ? 'instock' : 'outofstock',
                    ...$props,
                ];
            });

        return response($products);
    }
}
