<?php

namespace App\Http\Controllers\Main\Faq;

use App\Http\Controllers\Controller;
use App\Models\Faq;
use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Inertia\Inertia;

class FaqController extends Controller
{
    /** seo meta data */
    public array $seo = [
        'site_name' => null,
        'title' => null,
        'description' => null,
        'keywords' => null,
        'canonical' => null,
    ];

    /**
     * faqs list
     */
    public function index()
    {
        // main
        $shopTitle = Cache::remember('setting_shop_title', now()->addMonth(), function () {
            return Setting::where('key', 'shop_title')->first() != null ? Setting::where('key', 'shop_title')->first()->value : null;
        });

        $this->seo['site_name'] = $shopTitle;
        $this->seo['title'] = __('messages.word.faqs')  . ' - ' . $shopTitle;

        return Inertia::render('Main/Faq/List', [
            'faqs' => fn() => Faq::orderBy('created_at', 'desc')->get(),
            'seo' => $this->seo
        ])->title($this->seo['title'])->ogMeta()->twitterSummaryCard();
    }
}
