<?php

namespace App\Http\Controllers\Main\Pages;

use App\Http\Controllers\Controller;
use App\Models\Page;
use App\Models\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Inertia\Inertia;

class PagesController extends Controller
{
    /** seo meta data */
    public array $seo = [
        'site_name' => null,
        'title' => null,
        'description' => null,
        'keywords' => null,
        'canonical' => null,
    ];

    /**
     * Display the specified product
     */
    public function show(Request $request, Page $page)
    {
        // increase view count
        $page->update([
            'view_count' => $page->view_count + 1
        ]);

        $shopTitle = Cache::remember('setting_shop_title', now()->addMonth(), function () {
            return Setting::where('key', 'shop_title')->first() != null ? Setting::where('key', 'shop_title')->first()->value : null;
        });

        // main
        $this->seo['site_name'] = $shopTitle;
        $this->seo['title'] = ($page->seo_title != null ? $page->seo_title : $page->title) . ' - ' . $shopTitle;
        $this->seo['description'] = $page->seo_description;
        $this->seo['keywords'] = $page->get_seo_keywords;
        $this->seo['canonical'] = $page->seo_canonical;

        $view =  Inertia::render('Main/Pages/Show', [
            'page' => fn() => [
                'id' => $page->id,
                'title' => $page->title,
                'content' => $page->content,
            ],
            'seo' => $this->seo
        ]);

        $view->title($this->seo['title']);
        if ($this->seo['description'] != null) {
            $view->description($this->seo['description']);
        }
        $view->tag('<link rel="canonical" href="' . str_replace('%', '%%', $page->seo_canonical ?? urldecode(url()->full())) . '" />')
            ->ogMeta()
            ->ogUrl(urldecode(url()->full()))
            ->ogLocale('fa_IR')
            ->tag('<meta property="og:site_name" content="' . $this->seo['site_name'] . '" />')
            ->twitterSummaryCard()
            ->twitterSite($request->url())
            ->twitterCreator($this->seo['site_name']);

        return $view;
    }
}
