<?php

namespace App\Http\Controllers\Main\Products;

use App\Http\Controllers\Controller;
use App\Http\Requests\Main\ProductQuestionAddRequest;
use App\Http\Requests\Main\ProductQuestionAnswerAddRequest;
use App\Models\Product;
use App\Models\Question;
use App\Models\QuestionAnswer;
use Illuminate\Http\Request;

class QuestionsController extends Controller
{
    /**
     * add questions
     */
    public function add_question(ProductQuestionAddRequest $request, Product $product)
    {
        // check user login
        if (!auth()->check())
            return redirect()->back()->withErrors([__('messages.login_required')]);

        /** @var \App\Models\User $user */
        $user = auth()->user();

        $product->questions()->create([
            'user_id' => $user->id,
            'question' => $request->question,
            'status' => $user->type == 'owner' || $user->type == 'admin' || ($user->seller && $user->store->status == 'active') ? 'publish' : 'awaiting',
        ]);

        if ($user->type == 'owner' || $user->type == 'admin' || ($user->seller && $user->store->status == 'active'))
            return redirect()->back()->with('message', [__('messages.question_published')]);
        else
            return redirect()->back()->with('message', [__('messages.question_submited')]);
    }

    /**
     * add questions
     */
    public function add_answer(ProductQuestionAnswerAddRequest $request, Question $question)
    {
        // check user login
        if (!auth()->check())
            return redirect()->back()->withErrors([__('messages.login_required')]);

        /** @var \App\Models\User $user */
        $user = auth()->user();

        $question->questionAnswers()->create([
            'user_id' => $user->id,
            'answer' => $request->answer,
            'status' => $user->type == 'owner' || $user->type == 'admin' || ($user->seller && $user->store->status == 'active') ? 'publish' : 'awaiting',
        ]);

        if ($user->type == 'owner' || $user->type == 'admin' || ($user->seller && $user->store->status == 'active'))
            return redirect()->back()->with('message', [__('messages.question_answer_published')]);
        else
            return redirect()->back()->with('message', [__('messages.question_answer_submited')]);
    }

    /**
     * like answer
     */
    public function like_answer(Request $request, QuestionAnswer $answer)
    {
        $liked_answers = $request->session()->get('liked_answers', []);
        $disliked_answers = $request->session()->get('disliked_answers', []);

        if (!in_array($answer->id, $liked_answers) && !in_array($answer->id, $disliked_answers)) {
            $answer->update([
                'vote_up' => $answer->vote_up + 1
            ]);

            $liked_answers[] = $answer->id;
            session(['liked_answers' => $liked_answers]);
        }

        return redirect()->back();
    }

    /**
     * dislike answer
     */
    public function dislike_answer(Request $request, QuestionAnswer $answer)
    {
        $liked_answers = $request->session()->get('liked_answers', []);
        $disliked_answers = $request->session()->get('disliked_answers', []);

        if (!in_array($answer->id, $liked_answers) && !in_array($answer->id, $disliked_answers)) {
            $answer->update([
                'vote_down' => $answer->vote_down + 1
            ]);

            $disliked_answers[] = $answer->id;
            session(['disliked_answers' => $disliked_answers]);
        }

        return redirect()->back();
    }
}
