<?php

namespace App\Http\Controllers\Store;

use App\Http\Controllers\Controller;
use App\Services\Store\DashboardService;
use Illuminate\Http\Request;
use Inertia\Inertia;

class DashboardController extends Controller
{
    /**
     * store dashboard
     */
    public function index(DashboardService $dashboardService)
    {
        return Inertia::render('Store/Dashboard', [
            'salesAmount' => fn() => $dashboardService->getSalesAmount(),
            'salesChart' => fn() => $dashboardService->getSalesChart(7),
            'statisticsChart' => fn() => $dashboardService->getStatisticsChart(7),
            'consignments' => fn() => $dashboardService->getLatestConsignments(10),
        ]);
    }
}
