<?php

namespace App\Http\Controllers\Store\Financial;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Inertia\Inertia;

class TransactionsController extends Controller
{
    /**
     * transaction list
     */
    public function index(Request $request)
    {
        /** user
         * @var App\Models\User $user
         */
        $user = auth()->user();

        /** @var LengthAwarePaginator */
        $transactions = $user->transactions()->when($request->input('search'), function ($query, $search) {
            $query->where('transaction_id', 'like', "%{$search}%");
        })->when($request->input('accepted'), function ($query, $accepted) {
            if ($accepted) {
                $query->where('status', 'accepted');
            }
        })->when($request->input('rejected'), function ($query, $rejected) {
            if ($rejected) {
                $query->where('status', 'rejected');
            }
        })->when($request->input('deposit'), function ($query, $deposit) {
            if ($deposit) {
                $query->where('amount', '>', 0);
            }
        })->when($request->input('withdrawal'), function ($query, $withdrawal) {
            if ($withdrawal) {
                $query->where('amount', '<', 0);
            }
        })->orderBy('created_at', 'desc')->paginate(20);
        $transactions->withQueryString();

        return Inertia::render('Store/Financial/Transactions/List', [
            'transactions' => $transactions,
        ]);
    }
}
