<?php

namespace App\Http\Controllers\User\Account;

use App\Http\Controllers\Controller;
use Inertia\Inertia;
use Inertia\Response;

class NotificationsController extends Controller
{
    public function index(): Response
    {
        /** @var \App\Models\User $user */
        $user = auth()->user();

        // get notification list
        $notifications = $user->notifications()->latest()->paginate(10)->through(fn($notification) => [
            'data' => $notification->data,
            'read_at' => $notification->read_at
        ]);

        // mark as read all notifications
        $user->unreadNotifications->markAsRead();

        return Inertia::render('User/Account/Notifications', [
            'notifications' => $notifications
        ]);
    }
}
