<?php

namespace App\Http\Controllers\User\CustomerClub;

use App\Http\Controllers\Controller;
use App\Services\User\CustomerClub\ScoresService;
use Illuminate\Http\Request;
use Inertia\Inertia;

class CustomerClubController extends Controller
{
    /**
     * user score list
     */
    public function scores(Request $request, ScoresService $scoresService)
    {
        return Inertia::render('User/CustomerClub/Scores', [
            'scores' => $scoresService->getScores($request),
        ]);
    }
}
