<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\Product;
use App\Services\User\DashboardService;
use Illuminate\Http\Request;
use Inertia\Inertia;
use Inertia\Response;

class DashboardController extends Controller
{
    public function index(Request $request, DashboardService $dashboardService)
    {
        return Inertia::render('User/Dashboard', [
            'orders' => fn() => $dashboardService->getLatestOrders(5),
            'product_favorites' => fn() => $dashboardService->getProductFavorites(),
            'product_hitsory' => fn() => $dashboardService->getProductHistory($request),
        ]);
    }

    /**
     * banned user component view
     */
    public function banned(): Response
    {
        return Inertia::render('Errors/Banned', [])->title(__('messages.title.you_are_banned'));
    }
}