<?php

namespace App\Http\Controllers\User\Favorites;

use App\Http\Controllers\Controller;
use App\Models\ProductFavorite;
use Inertia\Inertia;

class FavoritesController extends Controller
{
    /**
     * product favorites list
     */
    public function index()
    {
        /** @var \App\Models\User $user */
        $user = auth()->user();

        /** @var LengthAwarePaginator */
        $productFavorites = $user->productFavorites()->orderBy('created_at', 'desc')->paginate(8)->through(fn($favorite) => [
            'product' => $favorite->get_product
        ]);

        $productFavorites->withQueryString();

        return Inertia::render('User/Favorites/List', [
            'product_favorites' => $productFavorites
        ]);
    }
}
