<?php

namespace App\Http\Controllers\User\Financial;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Inertia\Inertia;

class PrefactorsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        /** @var \App\Models\User $user */
        $user = auth()->user();

        /** @var LengthAwarePaginator */
        $prefactors = $user->prefactors()->where('status', '!=', 'awaiting_issuance')->where(function ($query) {
            $query->whereNull('expired_at')
                ->orWhere('expired_at', '>', now());
        })->with('user')->when($request->input('search'), function ($query, $search) {
            $query->where('uuid', 'like', "%{$search}%");
        })->when($request->input('paid'), function ($query, $paid) {
            if ($paid) {
                $query->where('status', 'paid');
            }
        })->when($request->input('waiting_payment'), function ($query, $waiting_payment) {
            if ($waiting_payment) {
                $query->where('status', 'waiting_payment');
            }
        })->orderBy('created_at', 'desc')->paginate(20)->through(fn($prefactor) => [
            'id' => $prefactor->id,
            'uuid' => $prefactor->uuid,
            'title' => $prefactor->title,
            'get_by' => $prefactor->get_by,
            'is_expired' => $prefactor->is_expired,
            'jalali_expired_at' => $prefactor->jalali_expired_at,
            'jalali_created_at' => $prefactor->jalali_created_at,
            'status' => $prefactor->status,
            'user' => [
                'id' => $prefactor->user->id,
                'get_name' => $prefactor->user->get_name,
            ],
        ]);
        $prefactors->withQueryString();

        return Inertia::render('User/Financial/Prefactors/List', [
            'prefactors' => $prefactors,
        ]);
    }
}
