<?php

namespace App\Http\Controllers\User\History;

use App\Http\Controllers\Controller;
use App\Models\Product;
use Illuminate\Http\Request;
use Inertia\Inertia;

class HistoryController extends Controller
{
    /**
     * user product history
     */
    public function index(Request $request)
    {
        $productHitsory = $request->session()->get('last_viewed_product');
        if ($productHitsory != null || (is_array($productHitsory) && count($productHitsory) > 0)) {
            if (count($productHitsory) > 8) {
                $productHitsory = array_slice($productHitsory, -8, 8, true);
            }

            $productTemp = [];
            foreach ($productHitsory as $ph) {
                $product = Product::where('id', $ph['id'])->where('status', 'publish')->first();
                if ($product != null) {
                    $productTemp[] = [
                        'title' => $product->title,
                        'slug' => $product->slug,
                        'status' => $product->status,
                        'get_images' => $product->get_images,
                        'in_stock_status' => $product->in_stock_status,
                        'inventory' => $product->inventory,
                        'best_price' => $product->best_price,
                        'unique_color' => $product->unique_color,
                        'comments_info' => $product->comments_info,
                    ];
                }
            }

            $productHitsory = $productTemp;
            $productHitsory = array_reverse($productHitsory);
        } else {
            $productHitsory = [];
        }

        return Inertia::render('User/History/List', [
            'product_hitsory' => $productHitsory,
        ]);
    }
}
