<?php

namespace App\Http\Middleware;

use App\Models\Setting;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Symfony\Component\HttpFoundation\Response;

class AddSettingsMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // add manage-newsletters permission
        if (!Cache::has("release_of_order_amounts")) {
            if (Setting::where('key', 'release_of_order_amounts')->first() == null) {
                Setting::create(['key' => 'release_of_order_amounts', 'value' => '7']);
            }
            Cache::forever("release_of_order_amounts", true);
        }

        return $next($request);
    }
}
