<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class IsActive
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (auth()->check() && !$request->routeIs(['error.banned'])) {
            if (auth()->user()->status == "banned") {
                return redirect()->route('error.banned');
            }
        }

        if ($request->routeIs(['error.banned'])) {
            if (auth()->user()->status !== "banned") {
                return redirect()->route('index');
            }
        }

        return $next($request);
    }
}
