<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class IsSeller
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (auth()->check()) {
            /**
             * @var App\Models\User $user
             * */
            $user = auth()->user();

            if ($user->store != null && $user->seller) {
                return $next($request);
            }
        }

        return redirect()->route('index');
    }
}
