<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class DiscountRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $discountId = $this->route('discount')?->id;

        return [
            'title'      => ['required', 'string', 'max:255'],
            'code'       => [
                'required',
                'string',
                'max:255',
                'unique:discounts,code' . ($discountId ? ',' . $discountId : ''),
            ],
            'expire_at'  => ['required'],
            'max_use'    => ['required', 'integer', 'min:1'],
            'percent'    => ['required', 'numeric', 'min:0', 'max:100'],
            'max_amount' => ['required'],
            'for'        => ['required', 'array'],
        ];
    }
}
