<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class ProductUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'uuid' => ['nullable', 'regex:/^[A-Za-z0-9_-]+$/'],
            'title' => ['required', 'string', 'max:255'],
            'title_en' => ['max:255'],
            'slug' => ['max:255'],
            'tabs' => ['nullable', 'array'],
            'category' => 'required',
            'is_vip' => 'required',
            'question_status' => 'required',
            'comment_status' => 'required',
            'status' => 'required',
        ];
    }
}
