<?php

namespace App\Http\Requests\User;

use App\Models\User;
use App\Rules\NationalNumber;
use App\Rules\Username;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ProfileUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['nullable', 'email', 'lowercase', 'max:255', Rule::unique(User::class)->ignore(auth()->user()->id)],
            'username' => ['nullable', 'string', 'regex:/^\w*$/i', 'min:4', 'max:20', 'unique:users,username,' . auth()->user()->id, new Username()],
            'national_number' => ['nullable', 'string', new NationalNumber()],
        ];
    }
}
