<?php

namespace App\Imports;

use App\Helpers\ClientHelper;
use App\Models\Inventory;
use App\Models\Storage;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;
use Morilog\Jalali\Jalalian;

class StorageImport implements ToCollection
{
    use ClientHelper;

    protected Storage $storage;

    public function __construct(Storage $storage)
    {
        $this->storage = $storage;
    }

    /**
     * @param Collection $collection
     */
    public function collection(Collection $collection)
    {
        $storage = $this->storage;

        foreach ($collection as $row) {
            $inventory = Inventory::where('storage_id', $storage->id)->where('uuid', $row[2])->first();
            if ($inventory == null) continue;

            // price
            $price = (int)$this->faNumbersToEn(str_replace(',', '', $row[5]));
            if ($price == null || $price == '') continue;

            // discount price
            $discount_price = $this->faNumbersToEn(str_replace(',', '', $row[6]));
            $discount_price = $discount_price != null && $discount_price != '' ? (int)$discount_price : null;

            // check discount_price
            if ($discount_price > $price) {
                continue;
            }

            // discount price
            $discount_expire = $row[7];
            if ($discount_price != null && $discount_price > 0 && $discount_expire != null && $discount_expire != '') {
                try {
                    $timestamp = Jalalian::fromFormat('Y/m/d', $discount_expire)->getTimestamp();
                    $discount_expire = Jalalian::forge($timestamp)
                        ->toCarbon()
                        ->setTimezone('Asia/Tehran')
                        ->setTime(23, 59, 59)
                        ->format('Y-m-d H:i:s');
                } catch (\Exception $e) {
                    $discount_expire = null;
                }
            } else {
                $discount_expire = null;
            }

            // count
            $count = (int)$this->faNumbersToEn(str_replace(',', '', $row[8]));

            // purchase price
            $purchasePrice = $row[9] != null && $row[9] != '' ? (int)$this->faNumbersToEn(str_replace(',', '', $row[9])) : null;

            // update inventory
            $inventory->update([
                'price' => $price,
                'discount_price' => $discount_price,
                'discount_expire' => $discount_expire,
                'count' => $count,
                'purchase_price' => $purchasePrice,
            ]);
        }
    }
}
