<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Support\Facades\Cache;
use Morilog\Jalali\Jalalian;

class Affiliate extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'product_id',

        'bronze_commission',
        'silver_commission',
        'gold_commission',
    ];

    protected $casts = [
        'product_id' => 'integer',
        'bronze_commission' => 'double',
        'silver_commission' => 'double',
        'gold_commission' => 'double',
    ];

    /**
     * additional data
     */
    protected $appends = [
        'jalali_created_at',
        'jalali_updated_at',
    ];

    public function getJalaliCreatedAtAttribute()
    {
        $date = [
            Jalalian::forge($this->created_at)->format('%d %B %Y'),
            Jalalian::forge($this->created_at)->format('Y/m/d'),
            Jalalian::forge($this->created_at)->format('H:i - Y/m/d'),
            Jalalian::forge($this->created_at)->ago(),
            Jalalian::forge($this->created_at)->getTimestamp(),
        ];
        return $date;
    }

    public function getJalaliUpdatedAtAttribute()
    {
        $date = [
            Jalalian::forge($this->updated_at)->format('%d %B %Y'),
            Jalalian::forge($this->updated_at)->format('Y/m/d'),
            Jalalian::forge($this->updated_at)->format('H:i - Y/m/d'),
            Jalalian::forge($this->updated_at)->ago(),
            Jalalian::forge($this->updated_at)->getTimestamp(),
        ];
        return $date;
    }
    /** end append */

    /**
     * remove cache data in update
     */
    protected static function boot()
    {
        parent::boot();

        static::saved(function ($affiliate) {
            Cache::forget('product_affiliate_' . $affiliate->product_id);
        });

        static::deleted(function ($affiliate) {
            Cache::forget('product_affiliate_' . $affiliate->product_id);
        });
    }

    /* relationships **************/
    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }
}
