<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Morilog\Jalali\Jalalian;

class FormAnswer extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'form_id',
        'user_id',
        'answer',
        'flag',
    ];

    protected $casts = [
        'form_id' => 'integer',
        'user_id' => 'integer',
    ];

    /**
     * additional data
     */
    protected $appends = [
        'get_user',
        'get_answer',
        'jalali_created_at',
        'jalali_updated_at',
    ];

    public function getGetUserAttribute()
    {
        $user = null;
        if ($this->user_id != null) {
            $findUser = User::where('id', $this->user_id)->first();
            if ($findUser != null) {
                $user = $findUser->get_name;
            }
        }
        return $user;
    }

    public function getGetAnswerAttribute()
    {
        return $this->answer != null ? unserialize($this->answer) : [];
    }

    public function getJalaliCreatedAtAttribute()
    {
        $date = [
            Jalalian::forge($this->created_at)->format('%d %B %Y'),
            Jalalian::forge($this->created_at)->format('Y/m/d'),
            Jalalian::forge($this->created_at)->format('H:i - Y/m/d'),
            Jalalian::forge($this->created_at)->ago(),
            Jalalian::forge($this->created_at)->getTimestamp(),
        ];
        return $date;
    }

    public function getJalaliUpdatedAtAttribute()
    {
        $date = [
            Jalalian::forge($this->updated_at)->format('%d %B %Y'),
            Jalalian::forge($this->updated_at)->format('Y/m/d'),
            Jalalian::forge($this->updated_at)->format('H:i - Y/m/d'),
            Jalalian::forge($this->updated_at)->ago(),
            Jalalian::forge($this->updated_at)->getTimestamp(),
        ];
        return $date;
    }
    /** end append */

    /* relationships **************/
    public function form(): BelongsTo
    {
        return $this->belongsTo(Form::class);
    }
}
