<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;
use Morilog\Jalali\Jalalian;

class Menu extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'content',
        'place',
    ];

    /**
     * additional data
     */
    protected $appends = [
        'get_items',
        'jalali_created_at',
        'jalali_updated_at',

        'safe',
    ];

    public function getGetItemsAttribute()
    {
        return $this->content != null ? unserialize($this->content) : [];
    }

    public function getJalaliCreatedAtAttribute()
    {
        $date = [
            Jalalian::forge($this->created_at)->format('%d %B %Y'),
            Jalalian::forge($this->created_at)->format('Y/m/d'),
            Jalalian::forge($this->created_at)->format('H:i - Y/m/d'),
            Jalalian::forge($this->created_at)->ago(),
            Jalalian::forge($this->created_at)->getTimestamp(),
        ];
        return $date;
    }

    public function getJalaliUpdatedAtAttribute()
    {
        $date = [
            Jalalian::forge($this->updated_at)->format('%d %B %Y'),
            Jalalian::forge($this->updated_at)->format('Y/m/d'),
            Jalalian::forge($this->updated_at)->format('H:i - Y/m/d'),
            Jalalian::forge($this->updated_at)->ago(),
            Jalalian::forge($this->updated_at)->getTimestamp(),
        ];
        return $date;
    }

    public function getSafeAttribute()
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'content' => $this->content != null ? unserialize($this->content) : [],
            'place' => $this->place,
        ];
    }
    /** end append */

    /**
     * remove cache data in update
     */
    protected static function boot()
    {
        parent::boot();

        $menuKeys = [
            'header_main',
            'footer_main',
            'footer_menu_1',
            'footer_menu_2',
        ];

        static::saved(function () use ($menuKeys) {
            foreach ($menuKeys as $key)
                Cache::forget('menus-' . $key);
        });

        static::deleted(function () use ($menuKeys) {
            foreach ($menuKeys as $key)
                Cache::forget('menus-' . $key);
        });
    }
}
