<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cache;
use Morilog\Jalali\Jalalian;

class Template extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'title',
        'description',
        'image',
        'options',
        'options_backup',
        'top_banner',
        'header',
        'header_backup',
        'footer',
        'footer_backup',
        'data',
        'data_backup',
        'blog_data',
        'blog_data_backup',
        'type',
        'status',
    ];

    /**
     * additional data
     */
    protected $appends = [
        'get_top_banner',
        'get_options',
        'get_data',
        'get_blog_data',
        'jalali_created_at',
        'jalali_updated_at',
    ];

    public function getGetTopBannerAttribute()
    {
        $banner = [
            'desktop' => [
                'file_id' => null,
                'image' => null,
                'alt' => null,
            ],
            'mobile' => [
                'file_id' => null,
                'image' => null,
                'alt' => null,
            ],
            'link' => null,
        ];

        if ($this->top_banner != null) {
            $topBanner = unserialize($this->top_banner);
            $banner['link'] = $topBanner["link"];

            $fileDesktop = Cache::remember('files_' . $topBanner["desktop"]["file_id"], now()->addMonth(), function () use ($topBanner) {
                return File::find($topBanner["desktop"]["file_id"]);
            });
            if ($fileDesktop != null && $fileDesktop->type == "image") {
                $banner['desktop'] = [
                    'file_id' => $fileDesktop->id,
                    'image' => asset($fileDesktop->url),
                    'alt' => $fileDesktop->description,
                ];
            }

            $fileMobile = Cache::remember('files_' . $topBanner["mobile"]["file_id"], now()->addMonth(), function () use ($topBanner) {
                return File::find($topBanner["mobile"]["file_id"]);
            });
            if ($fileMobile != null && $fileMobile->type == "image") {
                $banner['mobile'] = [
                    'file_id' => $fileMobile->id,
                    'image' => asset($fileMobile->url),
                    'alt' => $fileMobile->description,
                ];
            }
        }

        return $banner;
    }

    public function getGetOptionsAttribute()
    {
        return unserialize($this->options);
    }

    public function getGetDataAttribute()
    {
        return unserialize($this->data);
    }

    public function getGetBlogDataAttribute()
    {
        return unserialize($this->blog_data);
    }

    public function getJalaliCreatedAtAttribute()
    {
        $date = [
            Jalalian::forge($this->created_at)->format('%d %B %Y'),
            Jalalian::forge($this->created_at)->format('Y/m/d'),
            Jalalian::forge($this->created_at)->format('H:i - Y/m/d'),
            Jalalian::forge($this->created_at)->ago(),
            Jalalian::forge($this->created_at)->getTimestamp(),
        ];
        return $date;
    }

    public function getJalaliUpdatedAtAttribute()
    {
        $date = [
            Jalalian::forge($this->updated_at)->format('%d %B %Y'),
            Jalalian::forge($this->updated_at)->format('Y/m/d'),
            Jalalian::forge($this->updated_at)->format('H:i - Y/m/d'),
            Jalalian::forge($this->updated_at)->ago(),
            Jalalian::forge($this->updated_at)->getTimestamp(),
        ];
        return $date;
    }
    /** end append */

    /**
     * remove cache data in update
     */
    protected static function boot()
    {
        parent::boot();

        static::saved(function () {
            Cache::forget('template');
        });

        static::deleted(function () {
            Cache::forget('template');
        });
    }
}
