<?php

namespace App\Notifications;

use App\Channels\SMSChannel;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Morilog\Jalali\Jalalian;

class AffiliateRevenue extends Notification
{
    use Queueable;

    private $shareAmount;
    private $productUrl;
    private $productTitle;

    /**
     * Create a new notification instance.
     */
    public function __construct($shareAmount, $productUrl, $productTitle)
    {
        $this->shareAmount = $shareAmount;
        $this->productUrl = $productUrl;
        $this->productTitle = $productTitle;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database', SMSChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): void
    {
        //
    }

    /**
     * Get the sms representation of the notification.
     */
    public function toSMS(object $notifiable): void
    {
        //
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'message' => __('messages.notification_affiliate_revenue', ['amount' => number_format($this->shareAmount), 'url' => $this->productUrl, 'title' => $this->productTitle]),
            'date' => Jalalian::now()->format('H:i - Y/m/d'),
        ];
    }
}
