<?php

namespace App\Notifications;

use App\Channels\SMSChannel;
use App\Models\Inventory;
use App\Services\Plugins\Sms\SmsService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Morilog\Jalali\Jalalian;

class InventoryStatus extends Notification
{
    use Queueable;

    private Inventory $inventory;
    private $status;

    /**
     * Create a new notification instance.
     */
    public function __construct(Inventory $inventory, $status)
    {
        $this->inventory = $inventory;
        $this->status = $status;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database', SMSChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): void
    {
        //
    }

    /**
     * Get the sms representation of the notification.
     */
    public function toSMS(object $notifiable): void
    {
        $inventoryStatus = null;
        switch ($this->status) {
            case "active":
                $inventoryStatus = __('messages.word.active');
                break;
            case "confirmation":
                $inventoryStatus = __('messages.word.confirmation');
                break;
            case "deactive":
                $inventoryStatus = __('messages.word.deactive');
                break;
            case "delete":
                $inventoryStatus = __('messages.word.delete');
                break;
        }

        try {
            SmsService::send($notifiable->phone, 'inventoryStatus', ['token' => $this->inventory->uuid, 'token2' => $inventoryStatus]);
        } catch (\Exception $e) {
        }
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable)
    {
        $inventoryStatus = null;
        switch ($this->status) {
            case "active":
                $inventoryStatus =  '<span class="badge bg-success text-success fs-8">' . __('messages.word.active') . '</span>';
                break;
            case "confirmation":
                $inventoryStatus = '<span class="badge bg-success text-success fs-8">' . __('messages.word.confirmation') . '</span>';
                break;
            case "deactive":
                $inventoryStatus = '<span class="badge bg-danger text-danger fs-8">' . __('messages.word.deactive') . '</span>';
                break;
            case "delete":
                $inventoryStatus =  '<span class="badge bg-danger text-danger fs-8">' . __('messages.word.delete') . '</span>';
                break;
        }

        $productParameter = ['uuid' => '<span class="badge bg-light text-gray fs-8">' . $this->inventory->uuid . '</span>', 'status' => $inventoryStatus];

        if ($inventoryStatus != null) {
            return [
                'message' => __('messages.notification_inventory_status_changed', $productParameter),
                'date' => Jalalian::now()->format('H:i - Y/m/d'),
            ];
        }
    }
}
