<?php

namespace App\Notifications;

use App\Channels\SMSChannel;
use App\Models\Order;
use App\Services\Plugins\Sms\SmsService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Morilog\Jalali\Jalalian;

class OrderSent extends Notification
{
    use Queueable;

    private $order_uuid;
    private $consignment_uuid;
    private $trackingCode;
    private $withCancelled;

    /**
     * Create a new notification instance.
     */
    public function __construct($order_uuid, $consignment_uuid, $trackingCode, $withCancelled)
    {
        $this->order_uuid = $order_uuid;
        $this->consignment_uuid = $consignment_uuid;
        $this->trackingCode = $trackingCode;
        $this->withCancelled = $withCancelled;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database', SMSChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): void
    {
        //
    }

    /**
     * Get the sms representation of the notification.
     */
    public function toSMS(object $notifiable): void
    {
        try {
            if ($this->withCancelled) {
                SmsService::send($notifiable->phone, 'orderSentWithCancelled', ['token' => $this->consignment_uuid, 'token2' => $this->order_uuid, 'token3' => $this->trackingCode]);
            } else {
                SmsService::send($notifiable->phone, 'orderSent', ['token' => $this->consignment_uuid, 'token2' => $this->order_uuid, 'token3' => $this->trackingCode]);
            }
        } catch (\Exception $e) {
        }
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        if ($this->withCancelled) {
            $message = __('messages.notification_order_sent_with_cancelled', ['consignment_id' => $this->consignment_uuid, 'order_id' => $this->order_uuid, 'tracking_code' => $this->trackingCode]);
        } else {
            $message = __('messages.notification_order_sent', ['consignment_id' => $this->consignment_uuid, 'order_id' => $this->order_uuid, 'tracking_code' => $this->trackingCode]);
        }

        return [
            'message' => $message,
            'date' => Jalalian::now()->format('H:i - Y/m/d'),
        ];
    }
}
