<?php

namespace App\Notifications;

use App\Channels\SMSChannel;
use App\Models\Prefactor;
use App\Services\Plugins\Sms\SmsService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Morilog\Jalali\Jalalian;

class PrefactorIssued extends Notification
{
    use Queueable;

    private Prefactor $prefactor;

    /**
     * Create a new notification instance.
     */
    public function __construct(Prefactor $prefactor)
    {
        $this->prefactor = $prefactor;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database', SMSChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): void
    {
        //
    }

    /**
     * Get the sms representation of the notification.
     */
    public function toSMS(object $notifiable): void
    {
        try {
            SmsService::send($notifiable->phone, 'PrefactorIssued', ['token' => $this->prefactor->uuid, 'token2' => $this->prefactor->jalali_expired_at[1], 'token3' => $this->prefactor->uuid]);
        } catch (\Exception $e) {
        }
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'message' => __('messages.notification_prefactor_issued', ['uuid' => $this->prefactor->uuid, 'expired_at' => $this->prefactor->jalali_expired_at[1], 'url' => route('prefactor.shiping', ['uuid' => $this->prefactor->uuid])]),
            'date' => Jalalian::now()->format('H:i - Y/m/d'),
        ];
    }
}
