<?php

namespace App\Notifications;

use App\Channels\SMSChannel;
use App\Models\Product;
use App\Services\Plugins\Sms\SmsService;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Morilog\Jalali\Jalalian;

class ProductNotification extends Notification
{
    use Queueable;

    private Product $product;
    private $type;

    /**
     * Create a new notification instance.
     */
    public function __construct(Product $product, $type)
    {
        $this->product = $product;
        $this->type = $type;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database', SMSChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): void
    {
        //
    }

    /**
     * Get the sms representation of the notification.
     */
    public function toSMS(object $notifiable): void
    {
        // Important: send with simple send ..., and array of numbers
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        $productType = null;
        switch ($this->type) {
            case "inventory":
                $productType = 'messages.notification_product_inventory_charged';
                break;
            case "discount":
                $productType = 'messages.notification_product_discount_set';
                break;
        }

        $productParameter = ['product' => '<span class="link-to-target link lts-05" target="product" parameter="' . $this->product->slug . '">' . $this->product->title . '</span>'];

        if ($productType != null) {
            return [
                'message' => __($productType, $productParameter),
                'date' => Jalalian::now()->format('H:i - Y/m/d'),
            ];
        }
    }
}