<?php

namespace App\Notifications;

use App\Channels\SMSChannel;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Morilog\Jalali\Jalalian;

class Raw extends Notification
{
    use Queueable;

    private $message;
    private bool $sendSms;
    private bool $sendEmail;

    /**
     * Create a new notification instance.
     */
    public function __construct($message, $sendSms, $sendEmail = false)
    {
        $this->message = $message;
        $this->sendSms = $sendSms;
        $this->sendEmail = $sendEmail;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database', SMSChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): void
    {
        if ($this->sendEmail) {
            //
        }
    }

    /**
     * Get the sms representation of the notification.
     */
    public function toSMS(object $notifiable): void
    {
        if ($this->sendSms) {
            //
        }
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'message' => $this->message,
            'date' => Jalalian::now()->format('H:i - Y/m/d'),
        ];
    }
}