<?php

namespace App\Notifications;

use App\Channels\SMSChannel;
use App\Services\Plugins\Sms\SmsService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Morilog\Jalali\Jalalian;

class RequestConsignment extends Notification
{
    use Queueable;

    private $uuid;

    /**
     * Create a new notification instance.
     */
    public function __construct($uuid)
    {
        $this->uuid = $uuid;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database', SMSChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): void
    {
        //
    }

    /**
     * Get the sms representation of the notification.
     */
    public function toSMS(object $notifiable): void
    {
        try {
            SmsService::send($notifiable->phone, 'requestConsignment', ['token' => $this->uuid]);
        } catch (\Exception $e) {
        }
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'message' => __('messages.notification_request_consignment', ['uuid' => $this->uuid]),
            'date' => Jalalian::now()->format('H:i - Y/m/d'),
        ];
    }
}
