<?php

namespace App\Notifications;

use App\Channels\SMSChannel;
use App\Services\Plugins\Sms\SmsService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Morilog\Jalali\Jalalian;

class SellerRevenue extends Notification
{
    use Queueable;

    private $consignmentUuid;
    private $shareAmount;

    /**
     * Create a new notification instance.
     */
    public function __construct($consignmentUuid, $shareAmount)
    {
        $this->consignmentUuid = $consignmentUuid;
        $this->shareAmount = $shareAmount;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database', SMSChannel::class];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): void
    {
        //
    }

    /**
     * Get the sms representation of the notification.
     */
    public function toSMS(object $notifiable): void
    {
        //
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'message' => __('messages.notification_seller_revenue', ['uuid' => $this->consignmentUuid, 'amount' => number_format($this->shareAmount)]),
            'date' => Jalalian::now()->format('H:i - Y/m/d'),
        ];
    }
}
