<?php

namespace App\Notifications;

use App\Models\Discount;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Morilog\Jalali\Jalalian;

class UserSingleDiscount extends Notification
{
    use Queueable;

    private Discount $discount;

    /**
     * Create a new notification instance.
     */
    public function __construct(Discount $discount)
    {
        $this->discount = $discount;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): void
    {
        //
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        $message = __('messages.sentence.a_discount_created_for_you', ['title' => $this->discount->title]) . '<br/>';
        $message .= __('messages.word.code') . ': <span class="badge bg-success text-success fs-8">' . $this->discount->code . '</span>' . '<br/>';
        $message .= __('messages.word.percent') . ': ' . __('messages.sentence.discount_percent_and_max_amount', ['percent' => $this->discount->percent, 'max_amount' => number_format($this->discount->max_amount)]) . '<br/>';
        $message .= __('messages.sentence.expire_date') . ': ' . $this->discount->jalali_expire_at[1];

        return [
            'message' => $message,
            'date' => Jalalian::now()->format('H:i - Y/m/d'),
        ];
    }
}