<?php

namespace App\Providers;

use App\Inertia\InertiaHttpGateway;
use App\Services\Database\SchemaUpdater;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Vite;
use Illuminate\Support\ServiceProvider;
use Inertia\Ssr\HttpGateway;

class AppServiceProvider extends ServiceProvider
{
    public $bindings = [
        HttpGateway::class => InertiaHttpGateway::class,
    ];

    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->singleton(SchemaUpdater::class, function ($app) {
            return new SchemaUpdater();
        });
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        if (!app()->environment(['local', 'testing'])) {
            if (request()->isSecure()) {
                URL::forceScheme('https');
            } else {
                if (app()->runningInConsole()) return;
                abort(response()->redirectTo('https://' . request()->getHttpHost() . request()->getRequestUri(), 301));
            }
        }

        Vite::useScriptTagAttributes([
            'defer' => true,
        ]);
    }
}
