<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class Username implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $temp = preg_match("/^[A-Za-z][A-Za-z0-9_]*[A-Za-z0-9]$/", $value);
        if (!$temp) {
            $fail('validation.username')->translate();
        }
    }
}
