<?php

namespace App\Services\Admin\Account;

use App\Models\Token;
use App\Models\User;
use Morilog\Jalali\Jalalian;
use Illuminate\Http\Request;

class ProfileService
{
    /** validate birthday */
    public function getBirthday(Request $request)
    {
        if ($request->filled('birthday')) {
            try {
                $jalali = Jalalian::fromFormat('Y/m/d', $request->birthday);
                $timestamp = $jalali->getTimestamp();

                if ($timestamp < 0) {
                    return null;
                }

                $carbon = $jalali->toCarbon()->setTimezone('Asia/Tehran');

                if ($carbon->isFuture()) {
                    return null;
                }

                return $carbon->format('Y-m-d H:i:s');
            } catch (\Exception $e) {
                return null;
            }
        }

        return null;
    }


    /** validate gender */
    public function getGender(Request $request)
    {
        if ($request->exists('gender') && $request->gender != '') {
            if ($request->gender == 'man' || $request->gender == 'woman' || $request->gender == 'unknown') {
                return $request->gender;
            }
        }

        return null;
    }

    /** validate social */
    public function getSocial(Request $request)
    {
        if ($request->exists('social') && $request->social != '') {
            $social = $request->social;
            if (is_array($social) && array_key_exists('instagram', $social) && array_key_exists('telegram', $social) && array_key_exists('twitter', $social) && array_key_exists('facebook', $social)) {
                return serialize($social);
            }
        }

        return null;
    }

    /** get ip location details */
    public function ipDetails($IPaddress)
    {
        $json = file_get_contents("https://iplocate.io/api/lookup/" . $IPaddress);
        $details = json_decode($json);
        return $details;
    }

    /** validate user sessions */
    public function getSessions(User $user)
    {
        $sessions = Token::where('user_id', $user->id)->where('used', true)->select('id', 'user_id', 'ip', 'meta', 'created_at')->orderBy('created_at', 'desc')->paginate(20);

        foreach ($sessions as $session) {
            $deviceMeta = unserialize($session->meta);
            if ($deviceMeta['location'] == null) {
                try {
                    $location = $this->ipDetails($session->ip);
                    $deviceMeta['location'] = [
                        'country' => $location->country,
                        'city' => $location->city,
                        'latitude' => $location->country,
                        'longitude' => $location->country
                    ];
                    $session->update([
                        'meta' => serialize($deviceMeta)
                    ]);
                } catch (\Exception $e) {
                    $deviceMeta['location'] = null;
                }
            }
        }

        return $sessions;
    }
}
