<?php

namespace App\Services\Admin\Financial;

use App\Models\Transaction;
use App\Models\Withdrawal;
use Illuminate\Http\Request;

class WithdrawalsService
{
    /** get all Withdrawals list */
    public function getWithdrawals(Request $request)
    {
        /** @var LengthAwarePaginator */
        $withdrawals = Withdrawal::query()->when($request->input('search'), function ($query, $search) {
            $query->where('transaction_id', 'like', "%{$search}%");
        })->when($request->input('awaiting'), function ($query, $awaiting) {
            if ($awaiting) {
                $query->where('status', 'awaiting')->orderBy('created_at', 'asc');
            }
        })->when($request->input('deposited'), function ($query, $deposited) {
            if ($deposited) {
                $query->where('status', 'deposited');
            }
        })->with('user')
            ->orderByRaw("FIELD(status , 'awaiting', 'deposited', 'deleted') ASC")
            ->orderBy('created_at', 'desc')->paginate(20)->through(fn($withdrawal) => [
                'id' => $withdrawal->id,
                'transaction_id' => $withdrawal->transaction_id,
                'tracking_code' => $withdrawal->tracking_code,
                'amount' => $withdrawal->amount,
                'get_bank_account' => $withdrawal->get_bank_account,
                'jalali_created_at' => $withdrawal->jalali_created_at,
                'status' => $withdrawal->status,
                'user' => [
                    'id' => $withdrawal->user->id,
                    'get_name' => $withdrawal->user->get_name,
                    'type' => $withdrawal->user->type,
                ],
            ]);
        $withdrawals->withQueryString();

        return $withdrawals;
    }
}
