<?php

namespace App\Services\Admin\Forms;

use App\Helpers\CommonFunctionsHelper;
use App\Models\Form;
use Illuminate\Http\Request;

class FormsService
{
    use CommonFunctionsHelper;

    /** init system forms */
    public function createSystemForms()
    {
        if (Form::where('slug', 'contact-us')->first() == null) {
            Form::create([
                'uuid' => 'form-' . rand(1000000, 9999999),
                'title' => __('messages.system_form_contact_us'),
                'slug' => 'contact-us',
                'description' => '',
                'fields' => serialize([
                    [
                        'id' => $this->randStr(10),
                        'title' => __('messages.word.fullname'),
                        'type' => 'text',
                        'status' => 'necessary',
                    ],
                    [
                        'id' => $this->randStr(10),
                        'title' => __('messages.word.phone'),
                        'type' => 'text',
                        'status' => 'necessary',
                    ],
                    [
                        'id' => $this->randStr(10),
                        'title' => __('messages.word.message'),
                        'type' => 'textarea',
                        'status' => 'necessary',
                    ],
                ]),
                'seo_title' => __('messages.system_form_contact_us'),
                'seo_description' => null,
                'seo_keywords' => null,
                'seo_canonical' => null,
                'flag' => 'system',
                'status' => 'publish',
            ]);
        }
    }

    /** get form list */
    public function getForms(Request $request)
    {
        /** @var LengthAwarePaginator */
        $forms = Form::query()->when($request->input('search'), function ($query, $search) {
            $query->where('title', 'like', "%{$search}%");
        })->when($request->input('publish'), function ($query, $publish) {
            if ($publish) {
                $query->where('status', 'publish');
            }
        })->when($request->input('draft'), function ($query, $draft) {
            if ($draft) {
                $query->where('status', 'draft');
            }
        })->withCount('formAnswers')->orderBy('created_at', 'desc')->paginate(20)->through(fn($form) => [
            'id' => $form->id,
            'title' => $form->title,
            'slug' => $form->slug,
            'get_unread_count' => $form->get_unread_count,
            'form_answers_count' => $form->form_answers_count,
            'get_formatted_view_count' => $form->get_formatted_view_count,
            'flag' => $form->flag,
            'jalali_updated_at' => $form->jalali_updated_at,
            'status' => $form->status,
        ]);

        $forms->withQueryString();

        return $forms;
    }

    /** validate form fields */
    public function validateFields(Request $request)
    {
        if (count($request->fields) == 0)
            return 'form_fields_empty';

        foreach ($request->fields as $field) {
            if ($field['title'] == null || $field['type'] == null || $field['status'] == null) {
                return 'form_field_empty';
            }
        }
    }

    /** validate form fields */
    public function getFormAnswers(Form $form)
    {
        /** @var LengthAwarePaginator */
        $answers = $form->formAnswers()->orderBy('created_at', 'desc')->paginate(20)->through(fn($answer) => [
            'id' => $answer->id,
            'user_id' => $answer->user_id,
            'get_user' => $answer->get_user,
            'get_answer' => $answer->get_answer,
            'jalali_created_at' => $answer->jalali_created_at,
            'flag' => $answer->flag,
        ]);
        $answers->withQueryString();

        return $answers;
    }
}
