<?php

namespace App\Services\Admin\Products;

use App\Models\Brand;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BrandsService
{
    /** get brand list */
    public function getBrands(Request $request)
    {
        /** @var LengthAwarePaginator */
        $brands = Brand::query()->where('status', '!=', 'deleted')->when($request->input('search'), function ($query, $search) {
            $query->where('title', 'like', "%{$search}%");
        })->when($request->input('active'), function ($query, $active) {
            if ($active) {
                $query->where('status', 'publish');
            }
        })->when($request->input('archive'), function ($query, $archive) {
            if ($archive) {
                $query->where('status', 'archive');
            }
        })->when($request->input('mostProduct'), function ($query, $mostProduct) {
            if ($mostProduct) {
                $query->withCount(['products'])->orderBy('products_count', 'desc');
            }
        })->when($request->input('mostViewer'), function ($query, $mostViewer) {
            if ($mostViewer) {
                $query->orderBy('view_count', 'desc');
            }
        })->withCount('articles')->orderBy('created_at', 'desc')->paginate(20)->through(fn($brand) => [
            'id' => $brand->id,
            'uuid' => $brand->uuid,
            'title' => $brand->title,
            'slug' => $brand->slug,
            'get_logo' => $brand->get_logo,
            'get_formatted_view_count' => $brand->get_formatted_view_count,
            'products_count' => $brand->products_count,
            'articles_count' => $brand->articles_count,
            'jalali_updated_at' => $brand->jalali_updated_at,
            'status' => $brand->status,
        ]);

        $brands->withQueryString();

        return $brands;
    }

    /** get brand trash list */
    public function getTrashBrands(Request $request)
    {
        /** @var LengthAwarePaginator */
        $brands = Brand::query()->where('status', 'deleted')->when($request->input('search'), function ($query, $search) {
            $query->where(DB::raw('concat(`title`, `title_en`)'), 'like', "%{$search}%");
        })->orderBy('created_at', 'desc')->paginate(20)->through(fn($brand) => [
            'id' => $brand->id,
            'uuid' => $brand->uuid,
            'title' => $brand->title,
            'slug' => $brand->slug,
            'get_logo' => $brand->get_logo,
            'get_formatted_view_count' => $brand->get_formatted_view_count,
            'products_count' => $brand->products_count,
            'articles_count' => $brand->articles_count,
            'jalali_updated_at' => $brand->jalali_updated_at,
            'status' => $brand->status,
        ]);
        $brands->withQueryString();

        return $brands;
    }
}
