<?php

namespace App\Services\Admin\Products;

use App\Models\ProductTag;
use Illuminate\Http\Request;

class ProductTagsService
{
    /** get tags list */
    public function getTags(Request $request)
    {
        /** @var LengthAwarePaginator */
        $tags = ProductTag::query()->where('status', '!=', 'deleted')->when($request->input('search'), function ($query, $search) {
            $query->where('title', 'like', "%{$search}%");
        })->orderBy('created_at', 'desc')->paginate(20);

        $tags->withQueryString();

        return $tags;
    }
}
