<?php

namespace App\Services\Admin\Reports;

use App\Models\Report;
use App\Models\User;
use Illuminate\Http\Request;

class ReportsService
{
    /** get report list */
    public function getReports(Request $request)
    {
        /** @var LengthAwarePaginator */
        $reports = Report::query()->when($request->input('search'), function ($query, $search) {
            $userByPhoneOrUsername = User::where('phone', $search)->orWhere('username', $search)->first();
            if ($userByPhoneOrUsername != null) {
                $search = $userByPhoneOrUsername->id;
            }
            $query->where('user_id', 'like', "%{$search}%");
        })->when($request->input('owner'), function ($query, $owner) {
            if ($owner) {
                $query->where('type', 'owner');
            }
        })->when($request->input('admin'), function ($query, $admin) {
            if ($admin) {
                $query->where('type', 'admin');
            }
        })->when($request->input('seller'), function ($query, $seller) {
            if ($seller) {
                $query->where('type', 'seller');
            }
        })->when($request->input('user'), function ($query, $user) {
            if ($user) {
                $query->where('type', 'user');
            }
        })->orderBy('created_at', 'desc')->paginate(20)->through(fn($report) => [
            'id' => $report->id,
            'full_content' => $report->full_content,
            'jalali_created_at' => $report->jalali_created_at,
        ]);

        $reports->withQueryString();

        return $reports;
    }
}
