<?php

namespace App\Services\Admin\Templates;

use App\Models\ArticleCategory;
use App\Models\ProductCategory;

class TemplatesService
{
    /** get category branch */
    public function getMainCategories()
    {
        $categories = [
            [
                'id' => 'all',
                'title' => __('messages.sentence.all_categories'),
                'dropdown_title' => __('messages.sentence.all_categories')
            ],
            [
                'id' => 'main',
                'title' => __('messages.sentence.main_categories'),
                'dropdown_title' => __('messages.sentence.main_categories')
            ],
            ...ProductCategory::where('status', 'publish')->where('parent_id', 0)->get()->map(fn($cat) => [
                'id' => $cat->id,
                'title' => __('messages.sentence.sub_categories_of_span') . $cat->title,
                'dropdown_title' => __('messages.sentence.sub_categories_of') . $cat->title
            ])->toArray()
        ];

        return $categories;
    }

    /** get category branch */
    public function getCategoriesBranch()
    {
        $categoriesWithChilds = [];
        $categories = ProductCategory::where('status', 'publish')->where('parent_id', 0)->get()->map(fn($catLevel1) => [
            'id' => $catLevel1->id,
            'title' => $catLevel1->title,
            'slug' => $catLevel1->slug,
            'seo_description' => $catLevel1->seo_description,
            'get_image' => $catLevel1->get_image,
            'level' => 'one',
            'childs' => ProductCategory::where('status', 'publish')->where('parent_id', $catLevel1->id)->get()->map(fn($catLevel2) => [
                'id' => $catLevel2->id,
                'title' => $catLevel2->title,
                'slug' => $catLevel2->slug,
                'seo_description' => $catLevel2->seo_description,
                'get_image' => $catLevel2->get_image,
                'level' => 'two',
                'childs' => ProductCategory::where('status', 'publish')->where('parent_id', $catLevel2->id)->get()->map(fn($catLevel3) => [
                    'id' => $catLevel3->id,
                    'title' => $catLevel3->title,
                    'slug' => $catLevel3->slug,
                    'seo_description' => $catLevel3->seo_description,
                    'get_image' => $catLevel3->get_image,
                    'level' => 'three',
                    'childs' => null,
                ]),
            ]),
        ]);

        foreach ($categories as $category) {
            $categoriesWithChilds[] = $category;
            foreach ($category['childs'] as $childLevelTwo) {
                $categoriesWithChilds[] = $childLevelTwo;
                foreach ($childLevelTwo['childs'] as $childLevelThree) {
                    $categoriesWithChilds[] = $childLevelThree;
                }
            }
        }

        return $categoriesWithChilds;
    }

    /** get products branch */
    public function getProductsList()
    {
        $productCategories = ProductCategory::where('status', 'publish')->get()->map(fn($category) => [
            "id" => $category->id,
            "label" => $category->title,
            "archive" => ["cat" => $category->slug]
        ])->toArray();

        $productList = [
            ["id" => "latest_products", "label" => __('messages.sentence.latest_products'), "archive" => ["latest" => true]],
            ["id" => "instant_offers", "label" => __('messages.sentence.instant_offers'), "archive" => ["latest" => true]],
            ["id" => "vip_products", "label" => __('messages.sentence.vip_products'), "archive" => ["vip" => true]],
            ["id" => "discounted_products", "label" => __('messages.sentence.discounted_products'), "archive" => ["discount" => true]],
            ["id" => "popular_products", "label" => __('messages.sentence.popular_products'), "archive" => ["popular" => true]],
            ["id" => "most_viewed_products", "label" => __('messages.sentence.most_viewed_products'), "archive" => ["most_viewed" => true]],
            ["id" => "most_sales_products", "label" => __('messages.sentence.most_sales_products'), "archive" => ["most_sale" => true]],
        ];

        return array_merge($productList, $productCategories);
    }

    /** get raw products branch */
    public function getRawProductsList()
    {
        $rawProductList = [
            ["id" => "latest_products", "label" => __('messages.sentence.latest_products'), "archive" => ["latest" => true]],
            ["id" => "instant_offers", "label" => __('messages.sentence.instant_offers'), "archive" => ["latest" => true]],
            ["id" => "vip_products", "label" => __('messages.sentence.vip_products'), "archive" => ["vip" => true]],
            ["id" => "discounted_products", "label" => __('messages.sentence.discounted_products'), "archive" => ["discount" => true]],
            ["id" => "popular_products", "label" => __('messages.sentence.popular_products'), "archive" => ["popular" => true]],
            ["id" => "most_viewed_products", "label" => __('messages.sentence.most_viewed_products'), "archive" => ["most_viewed" => true]],
            ["id" => "most_sales_products", "label" => __('messages.sentence.most_sales_products'), "archive" => ["most_sale" => true]],
        ];

        return $rawProductList;
    }

    /** get products branch */
    public function getArticlesList()
    {
        $articleCategories = ArticleCategory::where('status', 'publish')->get()->map(fn($category) => [
            "id" => $category->id,
            "label" => $category->title,
            "archive" => ["cat" => $category->slug]
        ])->toArray();

        $articleList = [
            ["id" => "latest_articles", "label" => __('messages.sentence.latest_articles'), "archive" => ["latest" => true]],
            ["id" => "random_articles", "label" => __('messages.sentence.random_articles'), "archive" => ["random" => true]],
            ["id" => "editor_choice_articles", "label" => __('messages.sentence.editor_choice_articles'), "archive" => ["editor_choice" => true]],
            ["id" => "most_viewed_articles", "label" => __('messages.sentence.most_viewed_articles'), "archive" => ["most_viewed" => true]],
        ];

        return array_merge($articleList, $articleCategories);
    }
}
