<?php

namespace App\Services\Admin\Users;

use App\Models\Role;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class RoleService
{
    /** get roles list */
    public function getRoles(Request $request)
    {
        /** @var LengthAwarePaginator */
        $roles = Role::query()->when($request->input('search'), function ($query, $search) {
            $query->where(DB::raw('concat(`name`, `label`)'), 'like', "%{$search}%");
        })->with('permissions')->with('users')->paginate(20);

        $roles->withQueryString();

        return $roles;
    }

    /** get admin list */
    public function getAdmins(Request $request)
    {
        /** @var LengthAwarePaginator */
        $admins = User::query()->when($request->input('search'), function ($query, $search) {
            $query->where(DB::raw('concat(`username`, `phone`)'), 'like', "%{$search}%");
        })->whereIn('type', ['admin', 'owner'])->with('roles')->paginate(20)->through(fn($admin) => [
            'id' => $admin->id,
            'get_avatar' => $admin->get_avatar,
            'get_name' => $admin->get_name,
            'phone' => $admin->phone,
            'username' => $admin->username,
            'type' => $admin->type,
            'jalali_created_at' => $admin->jalali_created_at,
            'status' => $admin->status,
            'role' => $admin->role != null ? $admin->role : null,
        ]);

        $admins->withQueryString();

        return $admins;
    }
}
